 
#ifndef _AF901X_H_
#define _AF901X_H_

#define DVB_USB_LOG_PREFIX "AF901X"
#include "dvb-usb.h"
#include "FS803A.h"


#define TUNER_FreeScale_FS803      130
#define TUNER_MAXLINEAR_MXL5003D      3
#define TUNER_MAXLINEAR_MXL5005D     13


extern int dvb_usb_af901x_debug;
#define deb_info(args...)   dprintk(dvb_usb_af901x_debug,0x01,args)
#define deb_fw(args...)     dprintk(dvb_usb_af901x_debug,0x02,args)
#define deb_fwdata(args...) dprintk(dvb_usb_af901x_debug,0x04,args)
#define deb_data(args...)   dprintk(dvb_usb_af901x_debug,0x08,args)

#define     LoadTunerInitScript      DRV_Af901xLoadTunerInitScript
#define     InitTuner                DRV_InitTuner
#define     SetTuner                 DRV_SetTuner
#define     AdjustTuner              DRV_AdjustTuner
#define     CalibrateTuner           DRV_CalibrateTuner


struct af901x_state {
	u8 channel_state;
	u16 fs803_if1[2];
};

typedef struct	_MercuryRequest
{
	u8	ucCmd;
	u8	ucSeqNo;
	u8	uc2WireAddr;
	u16	wStartAddr;
    u8  ucMbxCmd;
	u8	ucRegAddrBytes;
	u8	ucWriteDataLen;
	u8 * ucpWriteDataPtr;
    u8	ucReadDataLen;
	u8 * ucpReadDataPtr;
    u8  ucDataLen;
}MercuryRequest, *PMercuryRequest;

typedef struct {
    u32  regAddr;
    u8   regPos;
    u8   regLen;
    u8   regVal;
} RegDesc;

typedef struct _SIGNAL_RETRAIN {
    u8     ucPreTemp;
    u8     FirstAdjustStrongSignal ;
} SIGNAL_RETRAIN , *PSIGNAL_RETRAIN ;

typedef struct _FS803_INFO {
    FS803_Info_t AvailFS803;
    UserData userData;
} FS803_INFO , *PFS803_INFO ;

typedef struct _TUNER_INFO {
    u8 bInitTuner;
    u8 bSetFreq;
    u8 TunerId;
    int tunerIdx;
    u8 XtalType;
    u8 SawBw;
    u16 wIfFreq;
    u16 wIf1;
    u8 bRdSpecInv;
    u8 tunerAddress;
    FS803_INFO  MT_Info;
    u32 LastChannel;
    u8  PCBType;
} TUNER_INFO, *PTUNER_INFO;

typedef struct _FILTER_CONTEXT_HW {
    u32 ulCurrentFrequency;
    u8  ucCurrentBandWidth;
    u32 ulDesiredFrequency;
    u8  ucDesiredBandWidth;
    u8 GraphBuilt;
    TUNER_INFO tunerinfo;
    SIGNAL_RETRAIN sr;
    u32   gdwOrigFCW;     //move from AF901x.cpp [global variable]
    u8    gucOrigUnplugTh; //move from AF901x.cpp [global variable]
    u8    gucPreShiftIdx;    //move from AF901x.cpp [global variable]
} FILTER_CONTEXT_HW, *PFILTER_CONTEXT_HW;

// Context storage
typedef struct _DEVICE_CONTEXT {
    FILTER_CONTEXT_HW fc;
    u8 bDualTs;
    u16 MaxPacketSize;
    u8 bIrTblDownload;
    u32 TsFrameSize;
    u32 TsFrameSizeDw;
    u8  ucDemod2WireAddr;
    MT_AvoidSpursData_t* MT_TunerList[MT_TUNER_CNT];
    u32  MT_TunerCount;
} DEVICE_CONTEXT, *PDEVICE_CONTEXT;


struct af901x_ofdm_channel {
	u32 RF_kHz;
	u8  Bw;
	s16 nfft;
	s16 guard;
	s16 nqam;
	s16 vit_hrch;
	s16 vit_select_hp;
	s16 vit_alpha;
	s16 vit_code_rate_hp;
	s16 vit_code_rate_lp;
	u8  intlv_native;
};

typedef struct _TUNER_INIT_ENTRY {
    u8 tunerId;
    u8 addr;
    RegDesc *pInitScript;
    int initScriptNum;
    int *RfIfTbl;
} TUNER_INIT_ENTRY, *PTUNER_INIT_ENTRY;
extern TUNER_INIT_ENTRY TunerEntry[] ;

extern struct dvb_usb_device_properties af901x_devices[];
extern struct usb_device_id af901x_usb_id_table[];
extern struct usb_device *udevs;
extern PDEVICE_CONTEXT PDC;

extern int af901x_download_firmware(struct usb_device *udev,const struct firmware *fw);
extern int af901x_streaming_ctrl(struct dvb_usb_adapter *adap, int onoff);
extern int af901x_powerctrl(struct dvb_usb_device *d, int onoff);
extern int af901x_identify_state(struct usb_device *udev, struct dvb_usb_device_properties *props,
			struct dvb_usb_device_description **desc, int *cold);
extern int af901x_device_count;

extern int Afa901x_usb_init(struct usb_device *udev,PDEVICE_CONTEXT PDCs);
extern u32 Af901xGetIFAGC(u8 ucDemod2WireAddr,u8  ucSlaveDemod,u8 *ucpGain);
extern u32 Af901xWriteTunerRegs(u8 ucDemod2WireAddr,u8 ucSlaveDemod,u8 ucTuner2WireAddr,u8 ucTunerType,u16 wRegAddr,u8 ucCount,u8 * ucpBuf);
extern u32 Af901xReadTunerRegs(u8 ucDemod2WireAddr,u8 ucSlaveDemod,u8 ucTuner2WireAddr,u8 ucTunerType,u16 wRegAddr,u8 ucCount,u8 *  ucpBuf);

extern u32 USB_ReadTunerRegs(u8 ucDemod2WireAddr,u8 ucSlaveDemod,u8 ucTuner2WireAddr,u8 ucTunerType,u16 wRegAddr,u8 ucCount,u8 * ucpBuf);
extern u32 USB_WriteTunerRegs(u8 ucDemod2WireAddr,u8 ucSlaveDemod,u8 ucTuner2WireAddr,u8 ucTunerType,u16 wRegAddr,u8 ucCount,u8 * ucpBuf);
extern u32 USB_ReadEeprom(u8 ucEeprom2WireAddr,u16 wStartPos,u8 ucCount,u8 * ucpReadBuf);
extern u16 USB_ReadRegs(u8 ucDemod2WireAddr,u8 ucSlaveDemod,u16 wStartPos,u8 ucCount,u8 * ucpReadBuf);
extern int USB_GetCurrConfig(u32* ucpTemp);
extern u32 USB_DownloadFw(u8 ucDemod2WireAddr,u16 dwArrayCnt,u8 * ucpBufPtr);
extern u32 USB_ReDownloadFw(u8 check);
extern u32 USB_WriteRegs(u8 ucDemod2WireAddr,u8 ucSlaveDemod,u16 wStartPos,u8 ucCount,u8 * ucpWriteBuf);

extern u32 DRV_TunerPowerCtrl(u8 bPowerOn);
extern u32 DRV_Af901xSetFreq(u8 ucSlaveDemod,u32 dwFreq,u8 ucBw);
extern u32 DRV_InitTuner(u8 ucDemod2WireAddr,u8  ucSlaveDemod,u8  ucTuner2WireAddr,void * pTunerData);
extern u32 DRV_SetTuner(u8 ucDemod2WireAddr,u8 ucSlaveDemod,u8  ucTuner2WireAddr,u32 dwFreq,u8 ucBw);
extern u32 DRV_AdjustTuner(u8 ucDemod2WireAddr,u8 ucSlaveDemod,u8 ucTuner2WireAddr,u8 ucStrong);
extern u32 DRV_CalibrateTuner(u8 ucDemod2WireAddr,u8 ucSlaveDemod,u8 ucTuner2WireAddr,u32 f_in,u32 f_out,UData_t * f_IF1,SData_t * P_max,void * pf,void * pp);

extern u32 Do_Tuner_Init(u8 tmp);
extern u32 Do_Tuner_SetBW(u8 ucBw);
extern u32 Do_Tuner_SetFreq(u32 ucFreq,u8 ucBw);

extern u32 FS803_Set(u32 dwFreq,u8 ucBw);
extern u32 FS803_Calibrate(u8 tmp);

extern struct dvb_frontend * af901x_attach(u8 TMP);

extern u32 DL_MercuryInit(u8 tmp);
extern u32 DL_ApCtrl(u8	bOn);
extern u32 Af901xWriteRegBits(
    u8    ucDemod2WireAddr,
    u8    ucSlaveDemod,
    u16   wRegAddr,              // register address
    u8    ucPos,                 // start bit to write
    u8    ucLen,                 // number of bits to write
    u8    ucValue                // value to write to register
);
#endif
